#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include <EEPROM.h>

String html1 = "<!DOCTYPE html>\r\n<html>\r\n<head>\r\n<meta content=\"text/html; charset=ISO-8859-1\" http-equiv=\"content-type\">\r\n<title>WebSchalter</title>\r\n<form action=\"";
// String((val)?"/1.html":"/0.html")
String html2 = "\">\r\n<input value=\"ON/OFF\" style=\"";
String html3 = " width:5em;height:3em; font-size: 16px;\" type=\"submit\"></form>\r\n</head>\r\n<body>\r\n</body>\r\n</html>";

const char htmlFrame[] = "<!DOCTYPE html><html><head><meta charset=\"utf-8\"><title>IP Steckdose</title></head><body><h1>IP Steckdose</h1><script type=\"text/javascript\">setInterval(refreshIframe2, 3000);function refreshIframe2() { var frame = document.getElementById(\"Frame2\");frame.src = frame.src;}</script><iframe id=\"Frame2\" src=\"/\" name=\"IP Relais\" height=\"300\" width=\"300\" frameBorder=\"0\"></iframe></body></html>";
char ssid[32] = "1234\0";
char passphrase[64] = "567890\0"; 


int val = 1;
int i, port;

ESP8266WebServer *server;
EspClass esp;
void setup()
{
 
  digitalWrite(0, 1);
  pinMode(0, OUTPUT);
  pinMode(2, INPUT_PULLUP);
  digitalWrite(0, 1);

  Serial.begin(115200);
  Serial.println("\r\n") ;
  
  EEPROM.begin(66);
 sprungmarke:

  // Eeeprom einlesen
  for (i = 0; i < 32; i++) ssid[i] = EEPROM.read(i);
  for (i = 32; i < 64; i++) passphrase[i - 32] = EEPROM.read(i);
  //port = EEPROM.read(64);
  port = EEPROM.read(64);
  port +=EEPROM.read(65)*256;
  // Wenn EEPROM leer
  if (ssid[0] == 255)
  {
    Serial.println("SSID nicht konfiguriert\r\n") ;
    Serial.println("Weiter mit \"Enter\"\r\n") ;
    while (!Serial.available())yield();
    InputEEPR();
    goto sprungmarke;
  }
  
  WiFi.mode(WIFI_STA);               //  modus
  WiFi.begin(ssid, passphrase);
  WiFi.printDiag(Serial);
  while (WiFi.status() != WL_CONNECTED)
  {
    delay(500);
    Serial.print(".");
    if (Serial.available()) InputEEPR();
  }
  server = new ESP8266WebServer(port);
  Serial.println("");
  Serial.print("Verbunden mit ");
  Serial.println(ssid);
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());

  //  Bechandlung der Ereignissen anschlissen
  server->on("/", Ereignis_Index);
  server->on("/1.html", Ereignis_SchalteON);
  server->on("/0.html", Ereignis_SchalteOFF);
  server->on("/frame", Ereignis_Frame);

  server->begin();  // Starte den Server
  Serial.print("HTTP Server gestartet am Port: ");  
  Serial.println(port); 
 }  

void InputEEPR()
{

  String Text = "";
  char inser;
  inser = Serial.read();
  if (inser != 13)  return; // enter, 27 esc
schleife:  

  Serial.println("");
  Serial.println("Bitte auswaelen zum aendern");
  Serial.print("1. SSID:       ");
  Serial.println(ssid);
  Serial.print("2. Passwort:   ");
  Serial.println(passphrase);
  Serial.print("3. Serverport: ");
  Serial.println(port);
  Serial.println("4. Ausgang");
  Serial.println("5. Reset");
  Serial.println("");
  while (!Serial.available()) yield(); //warte bis etwas empfangen wird
  inser = Serial.read();
  switch (inser) 
  {
  case '1':
  Serial.println("Input SSID: ");
    for (i = 0; i < 32; i++)
    {
      while (!Serial.available()) yield(); //warte bis etwas empfangen wird
      inser = Serial.read();
      Serial.write(inser);
      if (inser == '\r') // Wenn zeile abgeschlossen ist
      {
        EEPROM.write(i, '\0');  //Stringende setzen
        break;                   // for schleife verlassen
      } else  EEPROM.write(i, inser);     //nechste Zeichen empfangen
    }
    Serial.println("\r\nOK");
    EEPROM.commit();
    for (i = 0; i < 32; i++) ssid[i] = EEPROM.read(i);
  break;
  case '2':
  Serial.println("Input Passwort: ");
    for (i = 32; i < 64; i++)
    {
      while (!Serial.available()) yield(); //warte bis etwas empfangen wird
      inser = Serial.read();
      Serial.write(inser);
      if (inser == '\r') // Wenn zeile abgeschlossen ist
      {
        EEPROM.write(i, '\0');  //Stringende setzen
        break;                   // for schleife verlassen
      } else EEPROM.write(i, inser);     //nechste Zeichen empfangen
    }
    Serial.println("\r\nOK");
    EEPROM.commit();
    
    for (i = 32; i < 64; i++) passphrase[i - 32] = EEPROM.read(i);
  break;
  case '3':
  Serial.println("Input Port: ");
    for (i = 0; i < 5; i++)
    {
      while (!Serial.available()) yield(); //warte bis etwas empfangen wird
      inser = Serial.read();
      Serial.write(inser);
      if (inser == '\r') break; // Wenn zeile abgeschlossen ist for schleife verlassen               
      else Text += (char)inser;  
    }
    Text += '\0';  //Stringende setzen
    Serial.println("\r\nOK");
    port=Text.toInt();
    char* p; 
    p= reinterpret_cast<char*>(&port);
    EEPROM.write(64,p[0]);
    EEPROM.write(65,p[1]);
    EEPROM.commit();
    port = EEPROM.read(64);
  port +=EEPROM.read(65)*256;
  break;
   case '4':
   // Eeeprom einlesen
  WiFi.begin(ssid, passphrase);
  return;   //Unterprogramm verlassen
  break;
  case '5':
  esp.reset();
  break;
  default:
  break;
  } 
  goto schleife;   
    
    
}

void Ereignis_SchalteON()    // Wird ausgef?hrt wenn "http://<ip address>/schalt" aufgerufen wurde
{
  val = 0;
  digitalWrite(0, val);
  server->send(200, "text/html", html1 + String((val) ? "/1.html" : "/0.html") + html2 + String((val) ? "BACKGROUND-COLOR: DarkGray;" : "BACKGROUND-COLOR: Chartreuse;") + html3 );
}

void Ereignis_SchalteOFF()    // Wird ausgef?hrt wenn "http://<ip address>/schalt" aufgerufen wurde
{
  val = 1;
  digitalWrite(0, val);
  server->send(200, "text/html", html1 + String((val) ? "/1.html" : "/0.html") + html2 + String((val) ? "BACKGROUND-COLOR: DarkGray;" : "BACKGROUND-COLOR: Chartreuse;") + html3 );
}

void Ereignis_Index()    // Wird ausgef?hrt wenn "http://<ip address>/" aufgerufen wurde
{
  server->send(200, "text/html", html1 + String((val) ? "/1.html" : "/0.html") + html2 + String((val) ? "BACKGROUND-COLOR: DarkGray;" : "BACKGROUND-COLOR: Chartreuse;") + html3 );
}

void Ereignis_Frame()    // Wird ausgef?hrt wenn "http://<ip address>/" aufgerufen wurde
{
  server->send(200, "text/html", htmlFrame );
}



void loop()
{
  if (Serial.available()) InputEEPR();
  server->handleClient();
  if (!digitalRead(2))
  {
    val = !val;
    digitalWrite(0, val);
    while (!digitalRead(2))server->handleClient();
  }

}

